/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.api.compatibility.tinkers.TinkersToolHelper;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.combat.CombatAIStates;
import com.minecolonies.api.entity.combat.threat.IThreatTableEntity;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.ai.combat.AttackMoveAI;
import com.minecolonies.coremod.entity.ai.combat.CombatUtils;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.util.NamedDamageSource;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.items.IItemHandler;

public class KnightCombatAI
extends AttackMoveAI<EntityCitizen> {
    private static final VisibleCitizenStatus KNIGHT_COMBAT = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/knight_combat.png"), "com.minecolonies.gui.visiblestatus.knight_combat");
    private static final int KNOCKBACK_CHANCE = 5;
    private final AbstractEntityAIGuard parentAI;
    private long lastAoeUseTime = 0L;
    private final int KNOCKBACK_COOLDOWN = 240;
    private final int MIN_TIME_TO_ATTACK = 8;
    private static final double COMBAT_SPEED = 1.0;

    public KnightCombatAI(EntityCitizen owner, ITickRateStateMachine stateMachine, AbstractEntityAIGuard parentAI) {
        super(owner, stateMachine);
        this.parentAI = parentAI;
        stateMachine.addTransition(new TickingTransition<IAIState>(CombatAIStates.ATTACKING, () -> true, this::attackProtect, 8));
    }

    protected IAIState attackProtect() {
        int shieldSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)((EntityCitizen)this.user).getInventoryCitizen(), Items.f_42740_);
        if (shieldSlot != -1 && this.target != null && this.target.m_6084_() && this.nextAttackTime - ((EntityCitizen)this.user).f_19853_.m_46467_() >= 8L && ((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SHIELD_USAGE) > 0.0) {
            ((EntityCitizen)this.user).getCitizenItemHandler().setHeldItem(InteractionHand.OFF_HAND, shieldSlot);
            ((EntityCitizen)this.user).m_6672_(InteractionHand.OFF_HAND);
            ItemStack shieldStack = ((EntityCitizen)this.user).getInventoryCitizen().getHeldItem(InteractionHand.OFF_HAND);
            CompoundTag nbt = shieldStack.m_41698_("BlockEntityTag");
            nbt.m_128365_("Patterns", (Tag)((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getColonyFlag());
            ((EntityCitizen)this.user).m_21391_((Entity)this.target, 180.0f, 180.0f);
            ((EntityCitizen)this.user).decreaseSaturationForContinuousAction();
        }
        return null;
    }

    @Override
    public boolean canAttack() {
        int weaponSlot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)((EntityCitizen)this.user).getInventoryCitizen(), ToolType.SWORD, 0, ((EntityCitizen)this.user).getCitizenData().getWorkBuilding().getMaxToolLevel());
        if (weaponSlot != -1) {
            ((EntityCitizen)this.user).getCitizenItemHandler().setHeldItem(InteractionHand.MAIN_HAND, weaponSlot);
            return true;
        }
        return false;
    }

    @Override
    protected void doAttack(LivingEntity target) {
        int fireLevel;
        if (((EntityCitizen)this.user).m_20270_((Entity)target) > 1.0f) {
            this.moveInAttackPosition(target);
        }
        ((EntityCitizen)this.user).m_6674_(InteractionHand.MAIN_HAND);
        ((EntityCitizen)this.user).m_5496_(SoundEvents.f_12317_, 1.0f, (float)SoundUtils.getRandomPitch(((EntityCitizen)this.user).m_21187_()));
        double damageToBeDealt = this.getAttackDamage();
        NamedDamageSource source = new NamedDamageSource(((EntityCitizen)this.user).m_7755_().getString(), (Entity)this.user);
        if (((Boolean)MineColonies.getConfig().getServer().pvp_mode.get()).booleanValue() && target instanceof Player) {
            source.m_19380_();
        }
        if ((fireLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)((EntityCitizen)this.user).m_21120_(InteractionHand.MAIN_HAND))) > 0) {
            target.m_20254_(fireLevel * 80);
        }
        if (((EntityCitizen)this.user).f_19853_.m_46467_() - this.lastAoeUseTime > 240L) {
            this.doAoeAttack((DamageSource)source, damageToBeDealt);
        }
        target.m_6469_((DamageSource)source, (float)damageToBeDealt);
        target.m_6703_((LivingEntity)this.user);
        if (target instanceof Mob && ((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.KNIGHT_TAUNT) > 0.0) {
            ((Mob)target).m_6710_((LivingEntity)this.user);
            if (target instanceof IThreatTableEntity) {
                ((IThreatTableEntity)target).getThreatTable().addThreat((LivingEntity)this.user, 5);
            }
        }
        ((EntityCitizen)this.user).m_5810_();
        ((EntityCitizen)this.user).decreaseSaturationForContinuousAction();
        ((EntityCitizen)this.user).getCitizenData().setVisibleStatus(KNIGHT_COMBAT);
        ((EntityCitizen)this.user).getCitizenItemHandler().damageItemInHand(InteractionHand.MAIN_HAND, 1);
    }

    private void doAoeAttack(DamageSource source, double damageToBeDealt) {
        if (((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.KNIGHT_WHIRLWIND) > 0.0 && ((EntityCitizen)this.user).m_21187_().nextInt(5) == 0) {
            List entities = ((EntityCitizen)this.user).f_19853_.m_45976_(LivingEntity.class, ((EntityCitizen)this.user).m_142469_().m_82377_(2.0, 0.5, 2.0));
            for (LivingEntity livingentity : entities) {
                if (livingentity == this.user || !this.isEntityValidTarget(livingentity) || livingentity instanceof ArmorStand) continue;
                livingentity.m_147240_(2.0, (double)Mth.m_14031_((float)(livingentity.m_146908_() * (float)Math.PI)), (double)(-Mth.m_14089_((float)(livingentity.m_146908_() * (float)Math.PI))));
                livingentity.m_6469_(source, (float)(damageToBeDealt / (double)entities.size()));
            }
            ((EntityCitizen)this.user).f_19853_.m_6263_(null, ((EntityCitizen)this.user).m_20185_(), ((EntityCitizen)this.user).m_20186_(), ((EntityCitizen)this.user).m_20189_(), SoundEvents.f_12317_, ((EntityCitizen)this.user).m_5720_(), 1.0f, 1.0f);
            double d0 = -Mth.m_14031_((float)(((EntityCitizen)this.user).m_146908_() * ((float)Math.PI / 180)));
            double d1 = Mth.m_14089_((float)(((EntityCitizen)this.user).m_146908_() * ((float)Math.PI / 180)));
            if (((EntityCitizen)this.user).f_19853_ instanceof ServerLevel) {
                ((ServerLevel)((EntityCitizen)this.user).f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123766_, ((EntityCitizen)this.user).m_20185_() + d0, ((EntityCitizen)this.user).m_20227_(0.5), ((EntityCitizen)this.user).m_20189_() + d1, 2, d0, 0.0, d1, 0.0);
            }
            this.lastAoeUseTime = ((EntityCitizen)this.user).f_19853_.m_46467_();
        }
    }

    private int getAttackDamage() {
        int addDmg = 0;
        ItemStack heldItem = ((EntityCitizen)this.user).m_21120_(InteractionHand.MAIN_HAND);
        if (ItemStackUtils.doesItemServeAsWeapon(heldItem)) {
            addDmg = heldItem.m_41720_() instanceof SwordItem ? (int)((float)addDmg + (((SwordItem)heldItem.m_41720_()).m_43299_() + 3.0f)) : (int)((double)addDmg + TinkersToolHelper.getDamage(heldItem));
            addDmg = (int)((double)addDmg + (double)EnchantmentHelper.m_44833_((ItemStack)heldItem, (MobType)this.target.m_6336_()) / 2.5);
        }
        addDmg = (int)((double)addDmg + ((EntityCitizen)this.user).getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MELEE_DAMAGE));
        if ((double)((EntityCitizen)this.user).m_21223_() <= (double)((EntityCitizen)this.user).m_21233_() * 0.2) {
            addDmg *= 2;
        }
        return (int)((double)addDmg * (Double)MineColonies.getConfig().getServer().knightDamageMult.get());
    }

    @Override
    protected double getAttackDistance() {
        return 2.0;
    }

    @Override
    protected int getAttackDelay() {
        int reload = 32 - ((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) / 3;
        return Math.max(reload, 16);
    }

    @Override
    protected PathResult moveInAttackPosition(LivingEntity target) {
        return ((EntityCitizen)this.user).getNavigation().moveToXYZ(target.m_20185_(), target.m_20186_(), target.m_20189_(), this.getCombatMovementSpeed());
    }

    protected double getCombatMovementSpeed() {
        double levelAdjustment = (double)((EntityCitizen)this.user).getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) * 0.01;
        levelAdjustment += (double)(((EntityCitizen)this.user).getCitizenData().getWorkBuilding().getBuildingLevel() - 1) * 0.01;
        levelAdjustment = Math.min(levelAdjustment, 0.3);
        return 1.0 + levelAdjustment;
    }

    @Override
    protected boolean isAttackableTarget(LivingEntity entity) {
        return AbstractEntityAIGuard.isAttackableTarget((AbstractEntityCitizen)this.user, entity);
    }

    @Override
    protected boolean isWithinPersecutionDistance(LivingEntity target) {
        return this.parentAI.isWithinPersecutionDistance(target.m_142538_(), this.getAttackDistance());
    }

    @Override
    protected boolean skipSearch(LivingEntity entity) {
        EntityCitizen citizen;
        if (entity instanceof EntityCitizen && (citizen = (EntityCitizen)entity).getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && ((AbstractJobGuard)citizen.getCitizenJobHandler().getColonyJob()).isAsleep() && ((EntityCitizen)this.user).m_21574_().m_148306_((Entity)citizen)) {
            this.parentAI.setWakeCitizen(citizen);
            return true;
        }
        return false;
    }

    @Override
    protected void onTargetChange() {
        CombatUtils.notifyGuardsOfTarget((AbstractEntityCitizen)this.user, this.target, 1600);
    }

    @Override
    protected int getSearchRange() {
        return 0;
    }

    @Override
    protected void onTargetDied(LivingEntity entity) {
        this.parentAI.incrementActionsDoneAndDecSaturation();
        ((EntityCitizen)this.user).getCitizenExperienceHandler().addExperience(15.0);
    }
}

